
		.LA	3260		; HARDCODED COMPILATION ADDR


		MOV	#14001,@#177716	; PAGE 5 FROM 40000, ROM FROM 100000
		CLR	R3		; COLOR MASK
		CLR	R4		; COLOR DATA POINTER
		MOV	#1403,R5	; DOTMASK, 17=WORDWIDE, 1403=BYTESLIM
		MOV	#40000,R1

L1:		MOV	#8.,R2		; 8 WORD IN EACH COLUMN
L2:		SUB	#2,R4		; NEXT COLOR FOR NEXT COLUMN
		BPL	.+6
		ADD	#6,R4		; CYCLIC COLOR CHANGE

		MOV	#10.,R0		; COLUMN HEIGHT
L3:		MOV	COLORTAB(R4),(R1)
		BIC	R5,(R1)
		BIC	R3,(R1)+
		SOB	R0,L3
		BITB	#77,R1		; END OF LINE?
		BEQ	L4
		CLR	(R1)+		; INSERT EMPTY WORD BETWEEN COLUMNS
		BR	L2

L4:		ASL	R5		; DOTMASK CYCLED SHIFT
		ADC	R5
		ASL	R5
		ADC	R5
		SOB	R2,L2

		COM	R3
		BMI	.+12
		SUB	#2,R4
		ASL	R5		; +1 SHIFT FOR NEXT PALETTE
		ADC	R5
		MOV	PC,(SP)		; ALIGN SCROLL REG
		TST	R1
		BPL	L1

		ROR	R1		; BACK TO 40000
LOOP:		MOV	#INTERR,@#100
		CLRB	@#177663	; ENABLE VSYNC
		MOV	#177706,R4
		MOV	#177712,R5
		WAIT

COLORTAB:	.WORD	52525,125252,177777

INTERR:		MOV	(PC)+,R0		; PALETTE FOR FRAME START
PAL:		.WORD	0
		CMP	(SP)+,(SP)+
		MOVB	PC,(R4)		; TIMER START VALUE, 50 (HARDCODED)
		ADD	R2,(R4)		; TIMER LINE OFFSET 
		MOV	#30,(R5)
		SUB	#2,R2
		BPL	OLD_PAL
		MOV	#36,R2	
		INCB	PAL

OLD_PAL:	INCB	(SP)		; SCROLL COUNTER
		BNE	INT0		; SCROLL ALIGNED?
		MOV	#ALT_INT,@#100	; ALTERNATE INT ROUTINE IF YES
		DECB	TMP_PAL		; CHANGE PALETTE FOR ALT INT
		BMI	FINAL
		NEGB	ALT2+2		; SOUND CHANGER FOR ALT INT

INT0:		MOV	(SP),@#177664	; SET SCROLL PORT
		BIT	#20,(R5)		; AWAITING 1ST TIMER DELAY
		BNE	.-4

INT1:		INC	R0
		BICB	#340,R0
		MOVB	R0,@#177663	; CYCLED INC PALETTES
		MOVB	#36,(R4)
		MOV	#30,(R5)

INT2:		ADD	R0,R3
		BICB	#200,R3		; MASK #200 - DISABLE RELAY CLICKS
		MOVB	R3,@#177716	; GET SOUND
		BIT	#20,(R5)
		BNE	INT2
		BR	INT1

FINAL:		COM	R1		; SET ROM AS AUDIO/SCROLL DATA
		MTPS	R5		; DISABLE INTERRUPTS
		ROR	TMP_PAL		; SET SCREEN 0

ALT_INT:		CMP	(SP)+,(SP)+
		MOVB	(PC)+,@(PC)+	; SET PALETTE
TMP_PAL:	.WORD	5
		.WORD	177663

ALT2:		ADD	#1,R1		; 1 OR 255 - CYCLED CHANGE
		BIC	#20000,R1	; RESET BIT FOR R1 LOOPING
		CLRB	R5
		BISB	(R1),R5
		MOV	R5,@#177664	; SET SCROLL PORT
		MOVB	R5,@#177716	; GET SOUND
		SUB	#2,R4
JUMPER:		BMI	ALT2
		TST	R1		; R1 > 100000 = FINAL CYCLE
		BMI	ALT2
		BR	LOOP		; ELSE BACK TO MAIN LOOP

		.END